/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructureBuilder;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.world.structures.city.CityStructure;
import org.betterx.betternether.world.structures.templates.Altars;
import org.betterx.betternether.world.structures.templates.Gardens;
import org.betterx.betternether.world.structures.templates.GhastHive;
import org.betterx.betternether.world.structures.templates.JungleTemples;
import org.betterx.betternether.world.structures.templates.Pillars;
import org.betterx.betternether.world.structures.templates.Portals;
import org.betterx.betternether.world.structures.templates.Pyramids;
import org.betterx.betternether.world.structures.templates.RespawnPoints;
import org.betterx.betternether.world.structures.templates.SpawnAltarLadder;
import org.betterx.worlds.together.tag.v3.TagManager;

public class NetherStructures {
    public static final int CITY_SPACING = Configs.GENERATOR.getInt("generator.world.cities", "distance", 64);
    public static final BCLStructure<CityStructure> CITY_STRUCTURE = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("nether_city"), CityStructure::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(CITY_SPACING, CITY_SPACING >> 1)).build();
    public static final BCLStructure<Pyramids> PYRAMIDS = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("pyramid"), Pyramids::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(32, 8)).codec(Pyramids.CODEC).build();
    public static final BCLStructure<GhastHive> GHAST_HIVE = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("ghast_hive"), GhastHive::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(80, 32)).codec(GhastHive.CODEC).build();
    public static final BCLStructure<SpawnAltarLadder> SPAWN_ALTAR_LADDER = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("spawn_altar_ladder"), SpawnAltarLadder::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(40, 20)).codec(SpawnAltarLadder.CODEC).biomeTag(NetherTags.BETTER_NETHER_DECORATIONS)).build();
    public static final BCLStructure<RespawnPoints> RESPAWN_POINTS = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("respawn_points"), RespawnPoints::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(32, 24)).codec(RespawnPoints.CODEC).biomeTag(NetherTags.BETTER_NETHER_DECORATIONS)).build();
    public static final BCLStructure<Pillars> PILLARS = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("pillars"), Pillars::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(20, 8)).codec(Pillars.CODEC).biomeTag(NetherTags.BETTER_NETHER_DECORATIONS)).build();
    public static final BCLStructure<Gardens> GARDENS = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("gardens"), Gardens::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(50, 16)).codec(Gardens.CODEC).biomeTag(NetherTags.BETTER_NETHER_DECORATIONS)).build();
    public static final BCLStructure<Portals> PORTALS = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("portals"), Portals::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(40, 15)).codec(Portals.CODEC).biomeTag(NetherTags.BETTER_NETHER_DECORATIONS)).build();
    public static final BCLStructure<Altars> ALTARS = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("altars"), Altars::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(40, 16)).codec(Altars.CODEC).biomeTag(NetherTags.BETTER_NETHER_DECORATIONS)).build();
    public static final BCLStructure<JungleTemples> JUNGLE_TEMPLES = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterNether.makeID("jungle_temples"), JungleTemples::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(32, 8)).codec(JungleTemples.CODEC).biomeTag(NetherTags.BETTER_NETHER_DECORATIONS)).build();

    public static void register() {
        NetherStructurePieces.ensureStaticLoad();
        TagManager.BIOMES.add(NetherStructures.CITY_STRUCTURE.biomeTag, new ResourceKey[]{BiomeAPI.NETHER_WASTES_BIOME.getBiomeKey()});
        if (Configs.GENERATOR.getBoolean("generator.world.cities", "overworld", false)) {
            BiomeAPI.registerOverworldBiomeModification((biomeID, biome) -> {
                if (!biomeID.m_135827_().equals("betternether")) {
                    NetherStructures.addNonBNBiomeTags(biomeID, (Holder<Biome>)biome);
                }
            });
        }
    }

    public static void addNonBNBiomeTags(ResourceLocation biomeID, Holder<Biome> biome) {
        if (biomeID != null && !biomeID.equals((Object)BiomeAPI.BASALT_DELTAS_BIOME.getID()) && !biomeID.equals((Object)Biomes.f_48173_.m_135782_())) {
            TagManager.BIOMES.add(NetherStructures.CITY_STRUCTURE.biomeTag, (Object[])new Biome[]{(Biome)biome.m_203334_()});
        }
    }
}

